#ifndef TASKS_DMCONCENTRATORRADIOTASKTASK_H_
#define TASKS_DMCONCENTRATORRADIOTASKTASK_H_

#include "stdint.h"
#include "RadioProtocol.h"

#define CONCENTRATOR_ADVERTISE_INVALID  0x00

enum ConcentratorRadioOperationStatus {
    ConcentratorRadioStatus_Success,
    ConcentratorRadioStatus_Failed,
    ConcentratorRadioStatus_FailedNotConnected,
};

void RadioTask_Broadcast(void);

typedef void (*ConcentratorRadio_PacketReceivedCallback)(struct MOBtagPacket* packet, int8_t rssi);
typedef void (*ConcentratorRadio_BroadcastCallback)(void);

/* Create the ConcentratorRadioTask and creates all TI-RTOS objects */
void ConcentratorRadioTask_init(void);

void ConcentratorRadioTask_registerPacketReceivedCallback(ConcentratorRadio_PacketReceivedCallback callback);
void ConcentratorRadioTask_registerBroadcastCallback(ConcentratorRadio_BroadcastCallback callback);

#endif /* TASKS_DMCONCENTRATORRADIOTASKTASK_H_ */
